package parser.bnf;

import parser.*;
import java.util.*;

/**
 * BNF of BNF
 * 
 * S   ::= D | S1
 * S1  ::= lf S
 * D   ::=  WordToken "::=" E L
 * 
 * L   ::=  L2| Empty
 * L2  ::=  lf  L3
 * L3  ::=  L | D
 * 
 * E   ::=  T E1
 * E1  ::=  Empty | E1a
 * E1a ::=  "|" E
 * 
 * T   ::= T1 T2
 * T1  ::= WordToken| QuotedStringToken
 * T2  ::= Empty | T
 * 
 * This visitor to a grammar symbol will return a 
 * Map<String, IGrammarSymbol> that maps the name of every
 * non-terminal symbol in the grammar to an instance of 
 * the corresponding symbol.
 * 
 */
public class FindNonTerminalsAlgo extends AGramSymVisitor<Map<String,IGrammarSymbol>, Object> {
  
  private Map<String, IGrammarSymbol> result = new HashMap<String,IGrammarSymbol>();
  
  /**
   * Utility class for default error processing
   */
  private static class ErrorCmd<R> implements IGramSymVisitorCmd<R, Object> {
    private String symbolName;
    private R returnValue;
    
    ErrorCmd(String symbolName, R returnValue) {
      this.symbolName = symbolName;
      this.returnValue = returnValue;
    }
    
    public R apply(String idx, IGrammarSymbol host, Object... inps) {
      System.err.println("FindNonTerminalsAlgo: Invalid symbol encountered when process "+symbolName+" symbol = "+host);
      return returnValue;  
    }   
  }
  
  public FindNonTerminalsAlgo() {
    super(new ErrorCmd<Map<String,IGrammarSymbol>>("S", new HashMap<String, IGrammarSymbol>()));
    
    // STUDENT TO COMPLETE
    
  
    
  }
  
  
  private AGramSymVisitor<Map<String,IGrammarSymbol>, Object> dAlgo = new AGramSymVisitor<Map<String,IGrammarSymbol>, Object>(new ErrorCmd<Map<String,IGrammarSymbol>>("D", null)) {
    // Initializer block
    {
      setCmd("D", new IGramSymVisitorCmd<Map<String, IGrammarSymbol>,Object>() {
        public Map<String, IGrammarSymbol> apply(String idx, IGrammarSymbol host, Object... inps) {
          // STUDENT TO COMPLETE
  
          return null; // Stub code
        }
      });
    }
  };
  
  AGramSymVisitor<Map<String,IGrammarSymbol>, Object> lAlgo = new AGramSymVisitor<Map<String,IGrammarSymbol>, Object>(new ErrorCmd<Map<String,IGrammarSymbol>>("L", null)) {
    // Initializer block
    {
      // empty case:  done, return   
      setCmd("MTSymbol", new IGramSymVisitorCmd<Map<String,IGrammarSymbol>, Object>() {
        public Map<String,IGrammarSymbol> apply(String idx, IGrammarSymbol host, Object... inps) {
          System.out.println("Processing L = MT");
          return result;  
        }   
      });
      
      // L2 Sequence: process L3
      setCmd("L2", new IGramSymVisitorCmd<Map<String,IGrammarSymbol>, Object>() {        
        public Map<String,IGrammarSymbol> apply(String idx, IGrammarSymbol host, Object... inps) {
          System.out.println("Processing L = L2 = "+host);
          return ((SequenceSymbol) host).getSymbol2().execute(new AGramSymVisitor<Map<String,IGrammarSymbol>, Object>(new ErrorCmd<Map<String,IGrammarSymbol>>("L3", null)) {
            // Initializer block
            {
              // Combine the L & D processing to get the L3 processing
              setCmds(lAlgo.getCmds());
              setCmds(dAlgo.getCmds());
            }
          });
        }   
      });
    }
  };
  
  /**
   * Convenience method that returns the n'th symbol in a sequence.
   * Note that that unless the symbol is the last symbol in the 
   * sequence, the SequenceSymbol itself will be returned.  
   * @param h The start of the sequence. Unless n=0, this should be a SequenceSymbol
   * @param n The element in the sequence to return.  0 = the first symbol
   * @return A SequenceSymbol, unless n refers to the last symbol in a sequence, where it will be the symbol itself.
   */
  private IGrammarSymbol getNthInSequence(IGrammarSymbol h, int n) {
    IGrammarSymbol s = h;
    for(int i=0; i<n;i++) {
      s = ((SequenceSymbol)s).getSymbol2();
    }
    return s;
  }
}